/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.AlloyFurnaceBlockEntity;
import me.jddev0.ep.recipe.AlloyFurnaceRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_124;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8786;

public class AlloyFurnaceEMIRecipe
implements EmiRecipe {
    public static final class_2960 SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/alloy_furnace_front.png");
    public static final EmiStack ITEM = EmiStack.of((class_1935)EPBlocks.ALLOY_FURNACE_ITEM);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("alloy_furnace"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final OutputItemStackWithPercentages secondaryOutputWithPercentages;
    private final int ticks;

    public AlloyFurnaceEMIRecipe(class_8786<AlloyFurnaceRecipe> recipe) {
        this.id = recipe.comp_1932();
        this.input = Arrays.stream(((AlloyFurnaceRecipe)recipe.comp_1933()).getInputs()).map(input -> EmiIngredient.of((class_1856)input.input(), (long)input.count())).collect(Collectors.toList());
        this.output = Arrays.stream(((AlloyFurnaceRecipe)recipe.comp_1933()).getMaxOutputCounts()).filter(itemStack -> !itemStack.method_7960()).map(EmiStack::of).toList();
        this.secondaryOutputWithPercentages = ((AlloyFurnaceRecipe)recipe.comp_1933()).getSecondaryOutput();
        this.ticks = (int)((float)((AlloyFurnaceRecipe)recipe.comp_1933()).getTicks() * AlloyFurnaceBlockEntity.RECIPE_DURATION_MULTIPLIER);
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 149;
    }

    public int getDisplayHeight() {
        return 39;
    }

    public void addWidgets(WidgetHolder widgets) {
        int i;
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 65, 4);
        int len = Math.min(this.input.size(), 3);
        for (i = 0; i < len; ++i) {
            widgets.addSlot(this.input.get(i), 18 * i, 4);
        }
        for (i = len; i < 3; ++i) {
            widgets.addSlot((EmiIngredient)EmiStack.EMPTY, 18 * i, 4);
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 98, 0).large(true).recipeContext((EmiRecipe)this);
        SlotWidget secondaryOutputSlot = widgets.addSlot((EmiIngredient)(this.output.size() == 2 ? (EmiIngredient)this.output.get(1) : EmiStack.EMPTY), 124, 0).large(true).recipeContext((EmiRecipe)this);
        if (this.output.size() == 2) {
            secondaryOutputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages = this.secondaryOutputWithPercentages.percentages();
            for (int i2 = 0; i2 < percentages.length; ++i2) {
                secondaryOutputSlot.appendTooltip((class_2561)class_2561.method_43470((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i2 + 1, 100.0 * percentages[i2])));
            }
        }
        class_5250 ticksText = class_2561.method_43469((String)"recipes.energizedpower.info.ticks", (Object[])new Object[]{this.ticks});
        class_5481 class_54812 = ticksText.method_30937();
        int n = widgets.getWidth() - class_310.method_1551().field_1772.method_27525((class_5348)ticksText);
        int n2 = widgets.getHeight();
        Objects.requireNonNull(class_310.method_1551().field_1772);
        widgets.addText(class_54812, n, n2 - 9, class_124.field_1068.method_532().intValue(), false);
    }
}

